﻿#region usings
using System;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows;
using System.Windows.Forms;

using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing.Imaging;
using System.Drawing.Drawing2D;
using System.Threading;

using AForge.Video;
using AForge.Video.VFW;
using AForge.Video.DirectShow;
using AForge.Imaging.Filters;
using AForge;
using AForge.Imaging;
#endregion

namespace Image_analyzer
{
	public partial class FilterForm : Form
	{
		#region Vars...
		MainForm MF;
		public MainForm MainForm {
		    get { return MF; }
		    set { MF = value; }
		}
		int startmouse_y = 0;
		int startmouse_x = 0;
		#endregion
		
		#region Filterform
		public FilterForm()
		{
			InitializeComponent();
			do_erstelleRGBpaletten();
			tab_funktionen.TabPages.Remove(tabPage_conv);
			tab_funktionen.TabPages.Remove(tabPage_avr);
			tab_funktionen.TabPages.Remove(tabPage_pseudo);
			tab_funktionen.TabPages.Remove(tabPage_contrast);
			tab_funktionen.TabPages.Remove(tabPage_channel);
			tab_funktionen.TabPages.Remove(tabPage_rotateRGB);
			tab_funktionen.TabPages.Remove(tabPage_EcolorF);
			tab_funktionen.TabPages.Remove(tabPage_colorF);
			tab_funktionen.TabPages.Remove(tabPage_crop);
			tab_funktionen.TabPages.Remove(tabPage_blob);
			tab_funktionen.TabPages.Remove(tabPage_median); //
			tab_funktionen.TabPages.Remove(tabPage_extract);
			tab_funktionen.TabPages.Remove(tabPage_spiegeln);
			tab_funktionen.TabPages.Remove(tabPage_inter_vor);
			tab_funktionen.TabPages.Remove(tabPage_inter_nach);
			tab_funktionen.TabPages.Remove(tabPage_objektlabel);
			tab_funktionen.TabPages.Remove(tabPage_add_subst);
			tab_funktionen.TabPages.Remove(tabPage_verzerrung);
			tab_funktionen.TabPages.Remove(tabPage_Pointfill);
			tab_funktionen.TabPages.Remove(tabPage_motion);
			tab_funktionen.TabPages.Remove(tabPage_cam2);
			tab_funktionen.TabPages.Remove(tabPage_Ebenen);
		}
		void do_erstelleRGBpaletten()
		{
			//RGB0
			pic_rotate_rgb0.Image = new Bitmap(256, pic_rotate_rgb0.Height);
			Graphics G0 = Graphics.FromImage(pic_rotate_rgb0.Image);
			Rectangle rect0 = new Rectangle(0, 0, pic_rotate_rgb0.Image.Width, pic_rotate_rgb0.Image.Height);
			LinearGradientBrush GB0 = new LinearGradientBrush(rect0, Color.Red, Color.Blue, LinearGradientMode.Horizontal);
			ColorBlend CB0 = new ColorBlend(); CB0.Colors = new Color[] {Color.Blue, Color.Lime, Color.Red}; 
      		CB0.Positions = new float[] {0.0f,0.5f,1.0f};
      		GB0.InterpolationColors = CB0;
      		G0.FillRectangle(GB0, rect0);
			//RGB1
			pic_rotate_rgb1.Image = new Bitmap(256, pic_rotate_rgb1.Height);
			Graphics G1 = Graphics.FromImage(pic_rotate_rgb1.Image);
			Rectangle rect1 = new Rectangle(0, 0, pic_rotate_rgb1.Image.Width, pic_rotate_rgb1.Image.Height);
			LinearGradientBrush GB1 = new LinearGradientBrush(rect1, Color.Red, Color.Blue, LinearGradientMode.Horizontal);
			ColorBlend CB1 = new ColorBlend(); CB1.Colors = new Color[]{Color.Red,Color.Blue,Color.Lime};
      		CB1.Positions = new float[] {0.0f,0.5f,1.0f};
      		GB1.InterpolationColors = CB1;
      		G1.FillRectangle(GB1, rect1);
      		//RGB2
			pic_rotate_rgb2.Image = new Bitmap(256, pic_rotate_rgb2.Height);
			Graphics G2 = Graphics.FromImage(pic_rotate_rgb2.Image);
			Rectangle rect2 = new Rectangle(0, 0, pic_rotate_rgb2.Image.Width, pic_rotate_rgb2.Image.Height);
			LinearGradientBrush GB2 = new LinearGradientBrush(rect2, Color.Red, Color.Blue, LinearGradientMode.Horizontal);
			ColorBlend CB2 = new ColorBlend(); CB2.Colors = new Color[]{Color.Lime,Color.Red,Color.Blue};
      		CB2.Positions = new float[] {0.0f,0.5f,1.0f};
      		GB2.InterpolationColors = CB2;
      		G2.FillRectangle(GB2, rect2);
		}
		void Label_filter_setup2MouseEnter(object sender, EventArgs e)
		{
			label_filter_setup2.BackColor = Color.Red;
		}
		void Label_filter_setup2MouseLeave(object sender, EventArgs e)
		{
			label_filter_setup2.BackColor = Color.Silver;
		}
		void Label_filter_setup2Click(object sender, EventArgs e)
		{
			MF.filterToolStripMenuItem.PerformClick();
		}
		void Label_filter_setupMouseDown(object sender, MouseEventArgs e)
		{
			//label_filter_setup.BackColor = Color.RoyalBlue;
			startmouse_x = e.X;
			startmouse_y = e.Y;
			this.Opacity = 0.2d;
		}
		void Label_filter_setupMouseUp(object sender, MouseEventArgs e)
		{
			//label_filter_setup.BackColor = Color.LightSteelBlue;
			this.Opacity = 1d;
		}
		void Label_filter_setupMouseMove(object sender, MouseEventArgs e)
		{
			if (e.Button == MouseButtons.Left) {
				this.Top += e.Y - startmouse_y;
				this.Left += e.X - startmouse_x;
			}
		}
		void FilterFormActivated(object sender, EventArgs e)
		{
			label_filter_setup.BackColor = Color.RoyalBlue;
		}
		void FilterFormDeactivate(object sender, EventArgs e)
		{
			label_filter_setup.BackColor = Color.Gainsboro;
		}
		
		void CHK_topmostCheckedChanged(object sender, EventArgs e)
		{
			this.TopMost = CHK_topmost.Checked;
		}
		#endregion
		
		#region Kernels
		public void Kernel_öffne_kamera2()
		{
        	if ((CB_cam_devices2.SelectedIndex > 0) && (MF.video2 == null))
            {	//videoquelle starten
        		MF.timer_off.Enabled = false;
                MF.video2 = new VideoCaptureDevice(MF.videosources[CB_cam_devices2.SelectedIndex-1].MonikerString);
            	MF.video2.NewFrame += new NewFrameEventHandler(MF.video_NewFrame2);
            	MF.video2.DesiredFrameRate = (int)num_cam2_fps.Value;
            	MF.video2.DesiredFrameSize = new Size((int)num_cam2_breite.Value, (int)num_cam2_höhe.Value);
                MF.video2.Start();
                MF.timer_on.Enabled = true;
                //crop aktualisieren
                if (MF.video2.IsRunning == true) 
                {
                	CB_cam_devices2.ForeColor = Color.FromArgb(0,0,180,0);
                }
            }
		}
		public void Kernel_schließe_kamera2()
		{
			if (!(MF.video2 == null))
                if (MF.video2.IsRunning)
                {
                    MF.video2.SignalToStop();
                    MF.video2 = null;
                }
			MF.timer_on.Enabled = false;
			MF.timer_off.Enabled = true;
            CB_cam_devices2.ForeColor = Color.FromArgb(0,255,0,0);
            MF.working = false;
		}
		
		public void draw_dual_palette(Color startfarbe,Color endfarbe)
		{	//erzeuge einen Farbverlauf und eine dementsprechende farbtabelle
			
			//erstelle ein Bild mit 256 Pixeln, Farbwerte sind von 0-255 (byte)
			//also braucht man 1-256 Pixel zum auswerten
			pic_palette.Image = new Bitmap(256, pic_palette.Height);
			//Grafikobjekte erstellen
			Graphics G = Graphics.FromImage(pic_palette.Image);
			Rectangle rect = new Rectangle(0, 0, pic_palette.Image.Width, pic_palette.Image.Height);
			LinearGradientBrush GB = new LinearGradientBrush(rect, startfarbe, endfarbe, LinearGradientMode.Horizontal);
			//fülle das rechteck mit den übergebenen farben
			G.FillRectangle(GB, rect);
			
			//neue farbtabelle erstellen
			Bitmap img = (Bitmap)pic_palette.Image;
			Color col = new Color();
			for (int i = 0; i < 256; i++ ) 
			{
				col = img.GetPixel(i,1);
				MF.map_r[i] = col.R;
				MF.map_g[i] = col.G;
				MF.map_b[i] = col.B;
			}
		}
		public void draw_quad_palette()
		{	//erzeuge einen Farbverlauf und eine dementsprechende farbtabelle
			
			//erstelle ein Bild mit 256 Pixeln, Farbwerte sind von 0-255 (byte)
			//also braucht man 1-256 Pixel zum auswerten
			pic_palette.Image = new Bitmap(256, pic_palette.Height, PixelFormat.Format24bppRgb);
			//Grafikobjekte erstellen
			Graphics G = Graphics.FromImage(pic_palette.Image);
			Rectangle rect = new Rectangle(0, 0, pic_palette.Image.Width, pic_palette.Image.Height);
			LinearGradientBrush GB = new LinearGradientBrush(rect, Color.Red, Color.Blue, LinearGradientMode.Horizontal);
			//start und endfarbe mit neuen überschreiben
			ColorBlend CB = new ColorBlend();
			CB.Colors = new Color[]
			{
				panel_pseudo1.BackColor,
            	panel_pseudo2.BackColor,
            	panel_pseudo3.BackColor,
            	panel_pseudo4.BackColor,
			};
			//punkte festlegen, an denen die farben sein sollen, was dazwischen liegt
			//wird zum farbverlauf
      		float[] CP = new float[4];
      		//anfags und endpunkte müssen festliegen, 
      		//deshalb sind die anfangs und endfarben auch zweimal vorhanden
      		CP[0] = 0.0f;
      		CP[1] = 0.334f;
      		CP[2] = 0.667f;
      		CP[3] = 1.0f;
      			
      		//werte übergeben
      		CB.Positions = CP;
			GB.InterpolationColors = CB;
			
			//fülle das rechteck mit den übergebenen farben
			G.FillRectangle(GB, rect);
			
			//neue farbtabelle erstellen
			Bitmap img = (Bitmap)pic_palette.Image;
			Color col = new Color();
			for (int i = 0; i < 256; i++ ) 
			{
				col = img.GetPixel(i,1);
				MF.map_r[i] = col.R;
				MF.map_g[i] = col.G;
				MF.map_b[i] = col.B;
			}
		}
		public void draw_rainbow_palette()
		{	//erzeuge einen Farbverlauf und eine dementsprechende farbtabelle
			
			//erstelle ein Bild mit 256 Pixeln, Farbwerte sind von 0-255 (byte)
			//also braucht man 1-256 Pixel zum auswerten
			pic_palette.Image = new Bitmap(256, pic_palette.Height);
			//Grafikobjekte erstellen
			Graphics G = Graphics.FromImage(pic_palette.Image);
			Rectangle rect = new Rectangle(0, 0, pic_palette.Image.Width, pic_palette.Image.Height);
			LinearGradientBrush GB = new LinearGradientBrush(rect, Color.Red, Color.Blue, LinearGradientMode.Horizontal);
			//start und endfarbe mit neuen überschreiben
			ColorBlend CB = new ColorBlend();
			CB.Colors = new Color[]
			{
				Color.Black,
				Color.Black,
            	Color.DarkBlue,
            	Color.DodgerBlue,
            	Color.LimeGreen,
            	Color.Yellow,
            	Color.Gold,
            	Color.Red,
            	Color.White,
            	Color.White
			};
			//punkte festlegen, an denen die farben sein sollen, was dazwischen liegt
			//wird zum farbverlauf
      		float[] CP = new float[10];
      		//anfags und endpunkte müssen festliegen, 
      		//deshalb sind die anfangs und endfarben auch zweimal vorhanden
      		CP[0] = 0.0f;
      		CP[9] = 1.0f;
      		float span = (float) (((float)num_pseudo_span.Value - 7f) / 10f)*3;
      		float offset = (float) (((float)num_pseudo_offset.Value) / 12f)*3;
      		for (float i = 1; i < 9; i++ ) 
      		{	
      			CP[(int)i] = (float)( (i + (span*0.75) + offset) / ((span*1.5) + 9) );
      		}
      			
      		//werte übergeben
      		CB.Positions = CP;
			GB.InterpolationColors = CB;
			
			//fülle das rechteck mit den übergebenen farben
			G.FillRectangle(GB, rect);
			
			//neue farbtabelle erstellen
			Bitmap img = (Bitmap)pic_palette.Image;
			Color col = new Color();
			for (int i = 0; i < 256; i++ ) 
			{
				col = img.GetPixel(i,1);
				MF.map_r[i] = col.R;
				MF.map_g[i] = col.G;
				MF.map_b[i] = col.B;
			}
		}
		public void draw_rainbow_palette2()
		{	//erzeuge einen Farbverlauf und eine dementsprechende farbtabelle
			
			//erstelle ein Bild mit 256 Pixeln, Farbwerte sind von 0-255 (byte)
			//also braucht man 1-256 Pixel zum auswerten
			pic_palette.Image = new Bitmap(256, pic_palette.Height);
			//Grafikobjekte erstellen
			Graphics G = Graphics.FromImage(pic_palette.Image);
			Rectangle rect = new Rectangle(0, 0, pic_palette.Image.Width, pic_palette.Image.Height);
			LinearGradientBrush GB = new LinearGradientBrush(rect, Color.Red, Color.Blue, LinearGradientMode.Horizontal);
			//start und endfarbe mit neuen überschreiben
			ColorBlend CB = new ColorBlend();
			CB.Colors = new Color[]
			{
				Color.Black,
				Color.Black,
				
				Color.DarkBlue,
            	Color.Blue,
            	Color.Cyan,
            	Color.Lime,
            	Color.Yellow,
            	Color.Orange,
            	Color.Red,
            	Color.Magenta,
            	
            	Color.White,
            	Color.White
			};
			//punkte festlegen, an denen die farben sein sollen, was dazwischen liegt
			//wird zum farbverlauf
      		float[] CP = new float[CB.Colors.Length];
      		int lastindex = CB.Colors.Length - 1;
      		//anfags und endpunkte müssen festliegen, 
      		//deshalb sind die anfangs und endfarben auch zweimal vorhanden
      		CP[0] = 0.0f;
      		CP[lastindex] = 1.0f;
      		float span = (float) (((float)num_pseudo_span.Value - 7f) / 10f)*3;
      		float offset = (float) (((float)num_pseudo_offset.Value) / 12f)*3;
      		for (float i = 1; i < lastindex; i++ ) 
      		{	
      			CP[(int)i] = (float)( (i + (span*0.75) + offset) / ((span*1.5) + lastindex) );
      		}
      			
      		//werte übergeben
      		CB.Positions = CP;
			GB.InterpolationColors = CB;
			
			//fülle das rechteck mit den übergebenen farben
			G.FillRectangle(GB, rect);
			
			//neue farbtabelle erstellen
			Bitmap img = (Bitmap)pic_palette.Image;
			Color col = new Color();
			for (int i = 0; i < 256; i++ ) 
			{
				col = img.GetPixel(i,1);
				MF.map_r[i] = col.R;
				MF.map_g[i] = col.G;
				MF.map_b[i] = col.B;
			}
		}
		public void draw_ironbow_palette()
		{	//erzeuge einen Farbverlauf und eine dementsprechende farbtabelle
			
			//erstelle ein Bild mit 256 Pixeln, Farbwerte sind von 0-255 (byte)
			//also braucht man 1-256 Pixel zum auswerten
			pic_palette.Image = new Bitmap(256, pic_palette.Height, PixelFormat.Format24bppRgb);
			//Grafikobjekte erstellen
			Graphics G = Graphics.FromImage(pic_palette.Image);
			Rectangle rect = new Rectangle(0, 0, pic_palette.Image.Width, pic_palette.Image.Height);
			LinearGradientBrush GB = new LinearGradientBrush(rect, Color.Red, Color.Blue, LinearGradientMode.Horizontal);
			//start und endfarbe mit neuen überschreiben
			ColorBlend CB = new ColorBlend();
			CB.Colors = new Color[]
			{
				Color.Black,
				Color.Black,
            	Color.Blue,
            	Color.DarkViolet,
            	Color.Crimson,
            	Color.Orange,
            	Color.Yellow,
            	Color.White,
            	Color.White
			};
			//punkte festlegen, an denen die farben sein sollen, was dazwischen liegt
			//wird zum farbverlauf
      		float[] CP = new float[9];
      		//anfags und endpunkte müssen festliegen, 
      		//deshalb sind die anfangs und endfarben auch zweimal vorhanden
      		CP[0] = 0.0f;
      		CP[8] = 1.0f;
      		float span = (float) ( ((float)num_pseudo_span.Value - 7f) / 10f)*3;
      		float offset = (float) ( (float)num_pseudo_offset.Value / 12f)*3;
      		for (float i = 1; i < 8; i++ ) 
      		{	
      			CP[(int)i] = (float)( (i + (span*0.75) + offset) / ((span*1.5) + 8) );
      		}
      			
      		//werte übergeben
      		CB.Positions = CP;
			GB.InterpolationColors = CB;
			
			//fülle das rechteck mit den übergebenen farben
			G.FillRectangle(GB, rect);
			
			//neue farbtabelle erstellen
			Bitmap img = (Bitmap)pic_palette.Image;
			Color col = new Color();
			for (int i = 0; i < 256; i++ ) 
			{
				col = img.GetPixel(i,1);
				MF.map_r[i] = col.R;
				MF.map_g[i] = col.G;
				MF.map_b[i] = col.B;
			}
		}
		public void draw_sin_red_blue_palette()
		{
			//neue graustufen farbpalette
        	draw_dual_palette(Color.Black,Color.White);
        	
			//variablen erstellen
			double span = (double)num_pseudo_span.Value;
			double offset = (double)num_pseudo_offset.Value;
			double colspan = 270 - (span * 2);
			
			double math_span = (double)((double)num_pseudo_Mspan.Value/10);
			double math_offset = (double)num_pseudo_Moffset.Value;
			//Palette von 0-255 durchlaufen
        	for ( int i = 0; i < 256; i++ )
			{
				if (i < (span + offset)) 
				{	//schwarz am Anfang
					MF.map_r[i] = 0;
					MF.map_g[i] = 0;
					MF.map_b[i] = 0;
				} else if (i < (256 - (span - offset)))
				{
					// Neue Farbe [-1,1]:
					double red = Math.Sin( ((i+math_offset) - span - offset) * math_span * Math.PI / colspan - Math.PI);
					double green = Math.Sin( ((i+math_offset) - span - offset) * math_span * Math.PI / colspan - Math.PI / 2);
					double blue = Math.Sin( ((i+math_offset) - span - offset) * math_span * Math.PI / colspan);
					if (green < 0) {
						if (blue > red) {
							blue = 1;
							red = -1;
						}
						if (blue < red) {
							blue = -1;
							red = 1;
						}
					}
					// Neue Farbe [0,255]:
					red = (red + 1) * 0.5 * 255;
					green = (green + 1) * 0.5 * 255;
					blue = (blue + 1) * 0.5 * 255;
					
					MF.map_r[i] = (byte)red;
				    MF.map_g[i] = (byte)green;
				    MF.map_b[i] = (byte)blue;
				} else
				{	//weiß am Ende
					MF.map_r[i] = 255;
					MF.map_g[i] = 255;
					MF.map_b[i] = 255;
				}
			}
        	Bitmap img = (Bitmap)pic_palette.Image.Clone();
       		ColorRemapping filter2 = new ColorRemapping( MF.map_r, MF.map_g, MF.map_b );
        	pic_palette.Image = filter2.Apply(img);
		}
		public void draw_sin_rainbow_palette()
		{
			//neue graustufen farbpalette
        	draw_dual_palette(Color.Black,Color.White);
        	
			//variablen erstellen
			double span = (double)num_pseudo_span.Value;
			double offset = (double)num_pseudo_offset.Value;
			double colspan = 270 - (span * 2);
			
			double math_span = (double)((double)num_pseudo_Mspan.Value/10);
			double math_offset = (double)num_pseudo_Moffset.Value;
			//Palette von 0-255 durchlaufen
        	for ( int i = 0; i < 256; i++ )
			{
				if (i < (span + offset)) 
				{	//schwarz am Anfang
					MF.map_r[i] = 0;
					MF.map_g[i] = 0;
					MF.map_b[i] = 0;
				} else if (i < (256 - (span - offset)))
				{
					double red = 0;
					double green = 0;
					double blue = 0;
					// Neue Farbe [-1,1]:
					red = Math.Sin( ((i+math_offset) - span - offset) * math_span * Math.PI / colspan - Math.PI);
					green = Math.Sin( ((i+math_offset) - span - offset) * math_span * Math.PI / colspan - Math.PI / 2);
					blue = Math.Sin( ((i+math_offset) - span - offset) * math_span * Math.PI / colspan);
					
			
					// Neue Farbe [0,255]:
					red = (red + 1) * 0.5 * 255;
					green = (green + 1) * 0.5 * 255;
					blue = (blue + 1) * 0.5 * 255;
					
					MF.map_r[i] = (byte)red;
				    MF.map_g[i] = (byte)green;
				    MF.map_b[i] = (byte)blue;
				} else
				{	//weiß am Ende
					MF.map_r[i] = 255;
					MF.map_g[i] = 255;
					MF.map_b[i] = 255;
				}
			}
        	Bitmap img = (Bitmap)pic_palette.Image.Clone();
       		ColorRemapping filter2 = new ColorRemapping( MF.map_r, MF.map_g, MF.map_b );
        	pic_palette.Image = filter2.Apply(img);
		}
		public void draw_split_palette()
		{	//erzeuge einen Farbverlauf und eine dementsprechende farbtabelle
			
			//erstelle ein Bild mit 256 Pixeln, Farbwerte sind von 0-255 (byte)
			//also braucht man 1-256 Pixel zum auswerten
			pic_palette.Image = new Bitmap(256, pic_palette.Height, PixelFormat.Format24bppRgb);
			//Grafikobjekte erstellen
			Graphics G = Graphics.FromImage(pic_palette.Image);
			Rectangle rect = new Rectangle(0, 0, pic_palette.Image.Width, pic_palette.Image.Height);
			LinearGradientBrush GB = new LinearGradientBrush(rect, Color.Red, Color.Blue, LinearGradientMode.Horizontal);
			//start und endfarbe mit neuen überschreiben
			ColorBlend CB = new ColorBlend();
			CB.Colors = new Color[]
			{
				Color.MediumBlue,
            	Color.LightBlue,
            	Color.White,
            	Color.PeachPuff,
            	Color.SaddleBrown
			};
			//punkte festlegen, an denen die farben sein sollen, was dazwischen liegt
			//wird zum farbverlauf
      		float[] CP = new float[5];
      		//anfags und endpunkte müssen festliegen, 
      		//deshalb sind die anfangs und endfarben auch zweimal vorhanden
      		CP[0] = 0.0f;
      		CP[1] = 0.4f;
      		CP[2] = 0.5f;
      		CP[3] = 0.6f;
      		CP[4] = 1.0f;
      			
      		//werte übergeben
      		CB.Positions = CP;
			GB.InterpolationColors = CB;
			
			//fülle das rechteck mit den übergebenen farben
			G.FillRectangle(GB, rect);
			
			//neue farbtabelle erstellen
			Bitmap img = (Bitmap)pic_palette.Image;
			Color col = new Color();
			for (int i = 0; i < 256; i++ ) 
			{
				col = img.GetPixel(i,1);
				MF.map_r[i] = col.R;
				MF.map_g[i] = col.G;
				MF.map_b[i] = col.B;
			}
		}
		#endregion
		
		#region Controls
//Vorfilter #####################################################
		public void Check_cam2CheckedChanged(object sender, EventArgs e)
		{
			if (check_cam2.Checked) 
			{
				tab_funktionen.TabPages.Add(tabPage_cam2);
			} else {
				tab_funktionen.TabPages.Remove(tabPage_cam2);
			}
			
		}
		void Check_cam2_boxCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_Cam2 = check_cam2_box.Checked;
		}
		void Btn_cam2_startClick(object sender, EventArgs e)
		{
			Kernel_öffne_kamera2();
		}
		void Btn_cam2_stopClick(object sender, EventArgs e)
		{
			Kernel_schließe_kamera2();
		}
		void Num_cam2_BValueChanged(object sender, EventArgs e)
		{
			MF.Filt_Cam2_num_B = (int)num_cam2_B.Value;
		}
		void Num_cam2_HValueChanged(object sender, EventArgs e)
		{
			MF.Filt_Cam2_num_H = (int)num_cam2_H.Value;
		}
		void Num_cam2_xValueChanged(object sender, EventArgs e)
		{
			MF.Filt_Cam2_num_X = (int)num_cam2_x.Value;
		}
		void Num_cam2_yValueChanged(object sender, EventArgs e)
		{
			MF.Filt_Cam2_num_Y = (int)num_cam2_y.Value;
		}
		void Check_cam2_FilterCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_Cam2_useFilter = check_cam2_Filter.Checked;
		}
		
		void Check_spiegelnCheckedChanged(object sender, EventArgs e)
		{
    		MF.Filt_Siegeln = check_spiegeln.Checked;
    		if (check_spiegeln.Checked) 
			{
				tab_funktionen.TabPages.Add(tabPage_spiegeln);
			} else {
				tab_funktionen.TabPages.Remove(tabPage_spiegeln);
			}
		}
		void Check_spiegeln_HCheckedChanged(object sender, EventArgs e)
		{
			if (check_spiegeln_H.Checked)
    		{
    			panel_spiegeln.RowCount = 2;
    			panel_spiegeln.RowStyles.Add(new RowStyle(SizeType.Percent, 50));
    		} else {
    			panel_spiegeln.RowCount = 1;
    		}
			MF.Filt_Siegeln_H = check_spiegeln_H.Checked;
		}
		void Check_spiegeln_VCheckedChanged(object sender, EventArgs e)
		{
			if (check_spiegeln_V.Checked) 
    		{
    			panel_spiegeln.ColumnCount = 2;
    			panel_spiegeln.ColumnStyles.Add(new ColumnStyle(SizeType.Percent, 50));
    		} else {
    			panel_spiegeln.ColumnCount = 1;
    		}
    		MF.Filt_Siegeln_V = check_spiegeln_V.Checked;
		}
		
		void Check_inter_vorCheckedChanged(object sender, EventArgs e)
		{
			if (check_inter_vor.Checked) 
			{
				MF.pic_backfilter.Image = null;
				tab_funktionen.TabPages.Add(tabPage_inter_vor);
			} else
			{
				tab_funktionen.TabPages.Remove(tabPage_inter_vor);
			}
			MF.Filt_inter_vor = check_inter_vor.Checked;
		}
		void Num_inter_kleinerValueChanged(object sender, EventArgs e)
		{
			MF.Filt_inter_vor_val = (int)num_inter_kleiner.Value;
		}
		void Check_inter_bic_kleinerCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_inter_vor_bic = check_inter_bic_kleiner.Checked;
		}
		
		void Check_cropCheckedChanged(object sender, EventArgs e)
		{
			if (check_crop.Checked) 
			{
				MF.pic_backfilter.Image = null;
				tab_funktionen.TabPages.Add(tabPage_crop);
				MF.tbtn_filter_crop.ForeColor = Color.Lime;
			} else
			{
				check_crop_bereich.Checked = false;
				check_crop_move.Checked = false;
				tab_funktionen.TabPages.Remove(tabPage_crop);
				MF.tbtn_filter_crop.ForeColor = Color.Black;
			}
			MF.Filt_crop = check_crop.Checked;
		}
		void Check_crop_activeCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_crop_active = check_crop_active.Checked;
		}
		void Check_crop_bereichCheckedChanged(object sender, EventArgs e)
		{
			if (check_crop_bereich.Checked) 
			{
				check_crop_active.Checked = false;
				num_crop1.Value = 1;
				num_crop2.Value = 1;
				num_crop3.Value = MF.Picbox1.Image.Width - 1;
				num_crop4.Value = MF.Picbox1.Image.Height - 1;
			}
			MF.Filt_crop_new_set = check_crop_bereich.Checked;
		}
		void Check_crop_moveCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_crop_move = check_crop_move.Checked;
		}
		void Num_crop1ValueChanged(object sender, EventArgs e)
		{
			MF.Filt_crop_start_X = (int)num_crop1.Value;
		}
		void Num_crop2ValueChanged(object sender, EventArgs e)
		{
			MF.Filt_crop_start_Y = (int)num_crop2.Value;
		}
		void Num_crop3ValueChanged(object sender, EventArgs e)
		{
			MF.Filt_crop_stop_X = (int)num_crop3.Value;
		}
		void Num_crop4ValueChanged(object sender, EventArgs e)
		{
			MF.Filt_crop_stop_Y = (int)num_crop4.Value;
		}
		public void Btn_crop_resetClick(object sender, EventArgs e)
		{
			num_crop1.Value = 1;
			num_crop2.Value = 1;
			num_crop3.Value = MF.Picbox1.Image.Width - 1;
			num_crop4.Value = MF.Picbox1.Image.Height - 1;
		}
		void Panel_cropClick(object sender, EventArgs e)
		{
			if ( MF.colorDialog.ShowDialog() == DialogResult.OK )
			{ 
			   panel_crop.BackColor = MF.colorDialog.Color;
			   MF.Filt_crop_color = MF.colorDialog.Color;
			}
		}
//filter 1 #####################################################
		void Check_minCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_min = check_min.Checked;
		}
		void Check_maxCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_max = check_max.Checked;
		}
		void Check_invertCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_invert = check_invert.Checked;
		}
		void Panel_susanClick(object sender, EventArgs e)
		{
			if (MF.colorDialog.ShowDialog() == DialogResult.OK )
			{ 
			   panel_susan.BackColor = MF.colorDialog.Color;
			   MF.Filt_susan_color = MF.colorDialog.Color;
			}
		}
		void Check_susancornersCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_susan = check_susancorners.Checked;
		}
		void Check_sharpenCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_sharp = check_sharpen.Checked;
		}
		void Check_sharpen2CheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_sharp2 = check_sharpen2.Checked;
		}
		void Check_nurKantenCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_nurKanten = check_nurKanten.Checked;
			if (MF.Filt_nurKanten) {
				MF.Tbtn_filter_kanten.ForeColor = Color.Lime;
			} else {
				MF.Tbtn_filter_kanten.ForeColor = Color.Black;
			}
		}
		
		void Check_add_substractCheckedChanged(object sender, EventArgs e)
		{
			if (check_add_substract.Checked) 
			{
				tab_funktionen.TabPages.Add(tabPage_add_subst);
			} else
			{
				tab_funktionen.TabPages.Remove(tabPage_add_subst);
			}
			MF.Filt_AS = check_add_substract.Checked;
			if (pic_addbox.Image == null) {
				pic_addbox.Image = MF.Picbox1.Image;
			}
		}
		void Btn_add_grabClick(object sender, EventArgs e)
		{
			pic_addbox.Image = MF.Picbox1.Image;
		}
		void Check_addCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_AS_add = check_add.Checked;
		}
		void Check_differenceCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_AS_diff = check_difference.Checked;
		}
		void Check_substractCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_AS_substract = check_substract.Checked;
		}
		void Check_hintergrund_activeCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_AS_hintergr = check_hintergrund_active.Checked;
		}
		
		void Check_verzerrungCheckedChanged(object sender, EventArgs e)
		{
			if (check_verzerrung.Checked) 
			{
				tab_funktionen.TabPages.Add(tabPage_verzerrung);
			} else
			{
				tab_funktionen.TabPages.Remove(tabPage_verzerrung);
			}
			MF.Filt_Verzerrung = check_verzerrung.Checked;
		}
		void Check_jitterCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_Verzerrung_jitter = check_jitter.Checked;
		}
		void Num_jitterValueChanged(object sender, EventArgs e)
		{
			MF.Filt_Verzerrung_jitter_val = (int)num_jitter.Value;
		}
		void Check_oilpaintCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_Verzerrung_oil = check_oilpaint.Checked;
		}
		void Num_oilpaintValueChanged(object sender, EventArgs e)
		{
			MF.Filt_Verzerrung_oil_val = (int)num_oilpaint.Value;
		}
		void Check_pixellateCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_Verzerrung_pixelate = check_pixellate.Checked;
		}
		void Check_posterizationCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_Verzerrung_post = check_posterization.Checked;
		}
		void Check_waterwaveCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_Verzerrung_W_on = check_waterwave.Checked;
		}
		void Num_wave_1ValueChanged(object sender, EventArgs e)
		{
			MF.Filt_Verzerrung_W_1 = (int)num_wave_1.Value;
		}
		void Num_wave_2ValueChanged(object sender, EventArgs e)
		{
			MF.Filt_Verzerrung_W_2 = (int)num_wave_2.Value;
		}
		void Num_wave_3ValueChanged(object sender, EventArgs e)
		{
			MF.Filt_Verzerrung_W_3 = (int)num_wave_3.Value;
		}
		void Num_wave_4ValueChanged(object sender, EventArgs e)
		{
			MF.Filt_Verzerrung_W_4 = (int)num_wave_4.Value;
		}
		
		void Check_binaryCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_binary = check_binary.Checked;
		}
		void Num_medianValueChanged(object sender, EventArgs e)
		{
			MF.Filt_median_val = (int)num_median.Value;
		}
		void Check_medianCheckedChanged(object sender, EventArgs e)
		{
			if (check_median.Checked) 
			{
				tab_funktionen.TabPages.Add(tabPage_median);
			} else
			{
				tab_funktionen.TabPages.Remove(tabPage_median);
			}
			MF.Filt_median = check_median.Checked;
		}
		void Check_kantenCheckedChanged(object sender, EventArgs e)
		{
			if (check_kanten.Checked) 
			{
				MF.Tbtn_filter_convolution.ForeColor = Color.Lime;
				tab_funktionen.TabPages.Add(tabPage_conv);
			} else
			{
				MF.Tbtn_filter_convolution.ForeColor = Color.Black;
				tab_funktionen.TabPages.Remove(tabPage_conv);
			}
			MF.Filt_conv = check_kanten.Checked;
		}
		
		void But_kanten_set1Click(object sender, EventArgs e)
		{
			//Kernel setzen für kleine kanten
			num_kernel_1.Value = 0; num_kernel_2.Value = -1; num_kernel_3.Value = 0;
			num_kernel_4.Value = -1; num_kernel_5.Value = 4; num_kernel_6.Value = -1;
			num_kernel_7.Value = 0; num_kernel_8.Value = -1; num_kernel_9.Value = 0;
		}
		void But_kanten_set2Click(object sender, EventArgs e)
		{
			//Kernel setzen für schärfen
			num_kernel_1.Value = 5; num_kernel_2.Value = -5; num_kernel_3.Value = 5;
			num_kernel_4.Value = -5; num_kernel_5.Value = -5; num_kernel_6.Value = -5;
			num_kernel_7.Value = 5; num_kernel_8.Value = -5; num_kernel_9.Value = 5;
		}
		void But_kanten_set3Click(object sender, EventArgs e)
		{
			//Kernel setzen für emboss
			num_kernel_1.Value = -2; num_kernel_2.Value = -1; num_kernel_3.Value = 0;
			num_kernel_4.Value = -1; num_kernel_5.Value = -1; num_kernel_6.Value = 1;
			num_kernel_7.Value = 0; num_kernel_8.Value = 1; num_kernel_9.Value = 2;
		}
		void But_kanten_set4Click(object sender, EventArgs e)
		{
			
		}
		void num_kernel_ValChange(object sender, EventArgs e)
		{
			NumericUpDown Num = sender as NumericUpDown;
			switch (Num.Name.ToString()) {
				case "num_kernel_1": MF.Filt_conv_1 = (int)Num.Value; break;
				case "num_kernel_2": MF.Filt_conv_2 = (int)Num.Value; break;
				case "num_kernel_3": MF.Filt_conv_3 = (int)Num.Value; break;
				case "num_kernel_4": MF.Filt_conv_4 = (int)Num.Value; break;
				case "num_kernel_5": MF.Filt_conv_5 = (int)Num.Value; break;
				case "num_kernel_6": MF.Filt_conv_6 = (int)Num.Value; break;
				case "num_kernel_7": MF.Filt_conv_7 = (int)Num.Value; break;
				case "num_kernel_8": MF.Filt_conv_8 = (int)Num.Value; break;
				case "num_kernel_9": MF.Filt_conv_9 = (int)Num.Value; break;
			}
		}
		
		void Check_contrastCheckedChanged(object sender, EventArgs e)
		{
			if (check_contrast.Checked) 
			{
				tab_funktionen.TabPages.Add(tabPage_contrast);
			} else
			{
				tab_funktionen.TabPages.Remove(tabPage_contrast);
			}
			MF.Filt_Contrast = check_contrast.Checked;
		}
		void Scroll_contrastScroll(object sender, ScrollEventArgs e)
		{
			MF.Filt_Contrast_Cval = (double)scroll_contrast.Value / 1000;
			label_contrast.Text = ((double)scroll_contrast.Value / 1000).ToString();
		}
		void Scroll_helligkeitScroll(object sender, ScrollEventArgs e)
		{
			MF.Filt_Contrast_Hval = (double)scroll_helligkeit.Value / 1000;
			label_helligkeit.Text = ((double)scroll_helligkeit.Value / 1000).ToString();
		}
		void Btn_contrast_resetClick(object sender, EventArgs e)
		{
			scroll_contrast.Value = 1000;
			scroll_helligkeit.Value = 0;
			Scroll_contrastScroll(null,null);
			Scroll_helligkeitScroll(null,null);
		}
//filter 2 #####################################################
		void Check_colorFCheckedChanged(object sender, EventArgs e)
		{
			if (check_colorF.Checked) 
			{
				tab_funktionen.TabPages.Add(tabPage_colorF);
			} else
			{
				tab_funktionen.TabPages.Remove(tabPage_colorF);
			}
			MF.Filt_Color = check_colorF.Checked;
		}
		void Check_coloF_back_grayCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_Color_back_gray = check_coloF_back_gray.Checked;
		}
		void Panel_coloF_Typ2Click(object sender, EventArgs e)
		{
			if (MF.colorDialog.ShowDialog() == DialogResult.OK )
			{ 
			   panel_coloF_Typ2.BackColor = MF.colorDialog.Color;
			   MF.Filt_Color_typ2 = MF.colorDialog.Color;
			}
		}
		void Check_coloF_Typ2CheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_Color_usetyp2 = check_coloF_Typ2.Checked;
		}
		void num_col(object sender, EventArgs e)
		{
			NumericUpDown Num = sender as NumericUpDown;
			switch (Num.Name) {
				case "num_col_r": MF.Filt_Color_r1 = (byte)Num.Value; break;
				case "num_col_r2": MF.Filt_Color_r2 = (byte)Num.Value; break;
				case "num_col_g": MF.Filt_Color_g1 = (byte)Num.Value; break;
				case "num_col_g2": MF.Filt_Color_g2 = (byte)Num.Value; break;
				case "num_col_b": MF.Filt_Color_b1 = (byte)Num.Value; break;
				case "num_col_b2": MF.Filt_Color_b2 = (byte)Num.Value; break;
			}
		}
		void Check_channelFCheckedChanged(object sender, EventArgs e)
		{
			if (check_channelF.Checked) 
			{
				tab_funktionen.TabPages.Add(tabPage_channel);
			} else
			{
				tab_funktionen.TabPages.Remove(tabPage_channel);
			}
			MF.Filt_Chan = check_channelF.Checked;
		}
		void num_chan(object sender, EventArgs e)
		{
			NumericUpDown Num = sender as NumericUpDown;
			switch (Num.Name) {
				case "num_chan_r": MF.Filt_Chan_r1 = (byte)Num.Value; break;
				case "num_chan_r2": MF.Filt_Chan_r2 = (byte)Num.Value; break;
				case "num_chan_g": MF.Filt_Chan_g1 = (byte)Num.Value; break;
				case "num_chan_g2": MF.Filt_Chan_g2 = (byte)Num.Value; break;
				case "num_chan_b": MF.Filt_Chan_b1 = (byte)Num.Value; break;
				case "num_chan_b2": MF.Filt_Chan_b2 = (byte)Num.Value; break;
			}
		}
		void Check_euclideancolorFCheckedChanged(object sender, EventArgs e)
		{
			if (check_euclideancolorF.Checked) 
			{
				tab_funktionen.TabPages.Add(tabPage_EcolorF);
			} else
			{
				tab_funktionen.TabPages.Remove(tabPage_EcolorF);
			}
			MF.Filt_EC = check_euclideancolorF.Checked;
		}
		void num_EC(object sender, EventArgs e)
		{
			NumericUpDown Num = sender as NumericUpDown;
			switch (Num.Name) {
				case "num_ec_r": MF.Filt_EC_r = (byte)Num.Value; break;
				case "num_ec_g": MF.Filt_EC_g = (byte)Num.Value; break;
				case "num_ec_b": MF.Filt_EC_b = (byte)Num.Value; break;
				case "num_ec_radius": MF.Filt_EC_rad = (byte)Num.Value; break;
			}
		}
		void Check_rotateRGBCheckedChanged(object sender, EventArgs e)
		{
			if (check_rotateRGB.Checked) 
			{
				tab_funktionen.TabPages.Add(tabPage_rotateRGB);
			} 
			else
			{
				radio_rotateRGB0.Checked = true;
				tab_funktionen.TabPages.Remove(tabPage_rotateRGB);
			}
		}
		void radio_rotateRGB(object sender, EventArgs e)
		{
			RadioButton Radio = sender as RadioButton;
			switch (Radio.Name) {
				case "radio_rotateRGB0": MF.Filt_Rotate1 = false; MF.Filt_Rotate2 = false; break;
				case "radio_rotateRGB1": MF.Filt_Rotate1 = false; MF.Filt_Rotate2 = true; break;
				case "radio_rotateRGB2": MF.Filt_Rotate1 = true; MF.Filt_Rotate2 = false; break;
			}
		}
		void Check_extractRGBCheckedChanged(object sender, EventArgs e)
		{
			if (check_extractRGB.Checked) 
			{
				tab_funktionen.TabPages.Add(tabPage_extract);
			} else
			{
				tab_funktionen.TabPages.Remove(tabPage_extract);
			}
			MF.Filt_Extract = check_extractRGB.Checked;
		}
		void radio_extract(object sender, EventArgs e)
		{
			RadioButton Radio = sender as RadioButton;
			switch (Radio.Name) {
				case "radio_extract_R": MF.Filt_Extract_R = true; MF.Filt_Extract_G = false; MF.Filt_Extract_B = false; break;
				case "radio_extract_G": MF.Filt_Extract_R = false; MF.Filt_Extract_G = true; MF.Filt_Extract_B = false; break;
				case "radio_extract_B": MF.Filt_Extract_R = false; MF.Filt_Extract_G = false; MF.Filt_Extract_B = true; break;
			}
		}
		
		void Check_PointfillCheckedChanged(object sender, EventArgs e)
		{
			if (check_Pointfill.Checked) 
			{
				tab_funktionen.TabPages.Add(tabPage_Pointfill);
			} else
			{
				tab_funktionen.TabPages.Remove(tabPage_Pointfill);
				check_pointfill_setpoint.Checked = false;
			}
			MF.Filt_PFill = check_Pointfill.Checked;
		}
		void Panel_pointfillClick(object sender, EventArgs e)
		{
			if (MF.colorDialog.ShowDialog() == DialogResult.OK )
			{ 
			   panel_pointfill.BackColor = MF.colorDialog.Color;
			   MF.Filt_PFill_col = MF.colorDialog.Color;
			}
		}
		void num_pointfill(object sender, EventArgs e)
		{
			NumericUpDown Num = sender as NumericUpDown;
			switch (Num.Name) {
				case "num_pointfill_R": MF.Filt_PFill_R = (int)Num.Value; break;
				case "num_pointfill_G": MF.Filt_PFill_G = (int)Num.Value; break;
				case "num_pointfill_B": MF.Filt_PFill_B = (int)Num.Value; break;
				case "num_pointfill_x": MF.Filt_PFill_X = (int)Num.Value; break;
				case "num_pointfill_y": MF.Filt_PFill_Y = (int)Num.Value; break;
			}
		}
		void Check_pointfill_setpointCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_PFill_set = check_pointfill_setpoint.Checked;
		}
//Nachfilter #####################################################
		void Check_inter_nachCheckedChanged(object sender, EventArgs e)
		{
			if (check_inter_nach.Checked) 
			{
				tab_funktionen.TabPages.Add(tabPage_inter_nach);
			} else
			{
				tab_funktionen.TabPages.Remove(tabPage_inter_nach);
			}
			MF.Filt_inter_nach = check_inter_nach.Checked;
		}
		void Num_inter_größerValueChanged(object sender, EventArgs e)
		{
			MF.Filt_inter_nach_val = (int)num_inter_größer.Value;
		}
		void Check_inter_bic_größerCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_inter_nach_bic = check_inter_bic_größer.Checked;
		}
		void Check_avrCheckedChanged(object sender, EventArgs e)
		{
			if (check_avr.Checked) 
			{
				MF.pic_backfilter.Image = null;
				MF.tbtn_filter_average.ForeColor = Color.Lime;
				tab_funktionen.TabPages.Add(tabPage_avr);
			} else
			{
				tab_funktionen.TabPages.Remove(tabPage_avr);
				MF.tbtn_filter_average.ForeColor = Color.Black;
			}
			MF.Filt_AVR = check_avr.Checked;
		}
		void Num_avr2ValueChanged(object sender, EventArgs e)
		{
			MF.Filt_AVR_val = (int)num_avr2.Value;
		}
		
		void Check_motionCheckedChanged(object sender, EventArgs e)
		{
			if (check_motion.Checked) 
			{
				tab_funktionen.TabPages.Add(tabPage_motion);
			} else
			{
				tab_funktionen.TabPages.Remove(tabPage_motion);
				
			}
			MF.Filt_motion = check_motion.Checked;
		}
		void Panel_motionClick(object sender, EventArgs e)
		{
			if (MF.colorDialog.ShowDialog() == DialogResult.OK )
			{ 
			   panel_motion.BackColor = MF.colorDialog.Color;
			   MF.Filt_motion_color = MF.colorDialog.Color;
			}
		}
		void Check_motion_colorCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_motion_color_on = check_motion_color.Checked;
		}
		void Check_motion_AVRCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_motion_AVR = check_motion_AVR.Checked;
		}
		void Check_motion_sourceCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_motion_surce = check_motion_source.Checked;
		}
		void Check_motion_THCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_motion_TH = check_motion_TH.Checked;
		}
		void Num_motion_AVRValueChanged(object sender, EventArgs e)
		{
			MF.Filt_motion_AVR_val = (int)num_motion_AVR.Value;
		}
		void Num_motion_THValueChanged(object sender, EventArgs e)
		{
			MF.Filt_motion_TH_val = (int)num_motion_TH.Value;
		}
		
		void Check_blobcounterCheckedChanged(object sender, EventArgs e)
		{
			if (check_blobcounter.Checked)
			{
				MF.Tbtn_filter_objektfinder.ForeColor = Color.Lime;
				tab_funktionen.TabPages.Add(tabPage_blob);
			} else
			{
				MF.Tbtn_filter_objektfinder.ForeColor = Color.Black;
				tab_funktionen.TabPages.Remove(tabPage_blob);
			}
			MF.Filt_Blob = check_blobcounter.Checked;
		}
		void Check_blob_filterdataCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_Blob_showdata = check_blob_filterdata.Checked;
		}
		void Panel_objektcolorClick(object sender, EventArgs e)
		{
			if (MF.colorDialog.ShowDialog() == DialogResult.OK )
			{ 
			   panel_objektcolor.BackColor = MF.colorDialog.Color;
			   MF.Filt_Blob_color = MF.colorDialog.Color;
			}
		}
		void Check_blob_THCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_Blob_TH = check_blob_TH.Checked;
		}
		void Check_blob_THshowCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_Blob_THshow = check_blob_THshow.Checked;
		}
		void Num_threshotValueChanged(object sender, EventArgs e)
		{
			MF.Filt_Blob_TH_val = (int)num_threshot.Value;
		}
		void Num_objekt_HValueChanged(object sender, EventArgs e)
		{
			MF.Filt_Blob_minY = (int)num_objekt_H.Value;
		}
		void Num_objekt_WValueChanged(object sender, EventArgs e)
		{
			MF.Filt_Blob_minX = (int)num_objekt_W.Value;
		}
		void Radio_objekt_sizeCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_Blob_Abmessung = radio_objekt_size.Checked;
		}
		
		void Check_objektlabelCheckedChanged(object sender, EventArgs e)
		{
			if (check_objektlabel.Checked) 
			{
				tab_funktionen.TabPages.Add(tabPage_objektlabel);
			} else {
				tab_funktionen.TabPages.Remove(tabPage_objektlabel);
			}
			MF.Filt_ColBlob = check_objektlabel.Checked;
		}
		void Num_filter_objectlabelValueChanged(object sender, EventArgs e)
		{
			MF.Filt_ColBlob_THval = (int)num_filter_objectlabel.Value;
		}
		void Check_objektlabel_multicolorCheckedChanged(object sender, EventArgs e)
		{
			if (check_objektlabel_multicolor.Checked) {
				check_objektlabel_skeleton.Checked = false;
				check_objektlabel_kantenON.Checked = false;
			}
			MF.Filt_ColBlob_multicolor = check_objektlabel_multicolor.Checked;
		}
		void Check_objektlabel_skeletonCheckedChanged(object sender, EventArgs e)
		{
			if (check_objektlabel_skeleton.Checked) {
				check_objektlabel_multicolor.Checked = false;
			}
			MF.Filt_ColBlob_skelett = check_objektlabel_skeleton.Checked;
		}
		void Check_objektlabel_kantenONCheckedChanged(object sender, EventArgs e)
		{
			if (check_objektlabel_kantenON.Checked) {
				check_objektlabel_multicolor.Checked = false;
			}
			MF.Filt_ColBlob_kanten = check_objektlabel_kantenON.Checked;
		}
		
		void Check_pseudoCheckedChanged(object sender, EventArgs e)
		{
			if (check_pseudo.Checked) 
			{
				MF.Tbtn_filter_pseudocolor.ForeColor = Color.Lime;
				tab_funktionen.TabPages.Add(tabPage_pseudo);
			} else
			{
				MF.Tbtn_filter_pseudocolor.ForeColor = Color.Black;
				tab_funktionen.TabPages.Remove(tabPage_pseudo);
			}
			MF.Filt_Pseudo = check_pseudo.Checked;
		}
		void CB_filter_paletteSelectedIndexChanged(object sender, EventArgs e)
		{
			switch (CB_filter_palette.SelectedIndex) 
			{
				case 0:
				case 1:
				case 2:
				case 3:
				case 4:
				case 5: //ohne Farbeinstellung
					panel_pseudo1.Visible = false;
					panel_pseudo2.Visible = false;
					panel_pseudo3.Visible = false;
					panel_pseudo4.Visible = false;
					label_pseudo1.Visible = false;
					label_pseudo2.Visible = false;
					label_pseudo3.Visible = false;
					label_pseudo4.Visible = false;
					break;
				case 6: //mit 2 Farbeinstellung
					panel_pseudo1.Visible = true;
					panel_pseudo2.Visible = false;
					panel_pseudo3.Visible = false;
					panel_pseudo4.Visible = true;
					label_pseudo1.Visible = true;
					label_pseudo2.Visible = false;
					label_pseudo3.Visible = false;
					label_pseudo4.Visible = true;
					break;
				case 7: //mit 4 Farbeinstellung
					panel_pseudo1.Visible = true;
					panel_pseudo2.Visible = true;
					panel_pseudo3.Visible = true;
					panel_pseudo4.Visible = true;
					label_pseudo1.Visible = true;
					label_pseudo2.Visible = true;
					label_pseudo3.Visible = true;
					label_pseudo4.Visible = true;
					break;
			}
			switch (CB_filter_palette.SelectedIndex)
			{
				case 0: //grayscale
					draw_dual_palette(Color.Black,Color.White);
					break;
				case 1: //sinus red-blue
					draw_sin_red_blue_palette();
					break;
				case 2: //grad rainbow
					draw_rainbow_palette();
					break;
				case 3: //grad ironbow
					draw_ironbow_palette();
					break;
				case 4: //grad rainbow2
					draw_rainbow_palette2();
					break;
				case 5: //grad split
					draw_split_palette();
					break;
				case 6: //dual
					draw_dual_palette(panel_pseudo1.BackColor,panel_pseudo4.BackColor);
					break;
				case 7: //quad
					draw_quad_palette();
					break;
			}
			
		}
		void Num_pseudo_spanValueChanged(object sender, EventArgs e)
		{
			CB_filter_paletteSelectedIndexChanged(null,null);
		}
		void Panel_pseudo4Click(object sender, EventArgs e)
		{
			if (MF.colorDialog.ShowDialog() == DialogResult.OK) {
				Panel P = sender as Panel;
				P.BackColor = MF.colorDialog.Color;
				CB_filter_paletteSelectedIndexChanged(null,null);
			}
		}
		
		void Check_ebenenCheckedChanged(object sender, EventArgs e)
		{
			if (check_ebenen.Checked) 
			{
				tab_funktionen.TabPages.Add(tabPage_Ebenen);
			} else
			{
				tab_funktionen.TabPages.Remove(tabPage_Ebenen);
			}
			MF.Filt_Ebenen = check_ebenen.Checked;
		}
		void Btn_ebenen_1_grabClick(object sender, EventArgs e)
		{
			pic_ebene_1.Image = (Bitmap)MF.Picbox1.Image.Clone();
			MF.Ebene_1 = (Bitmap)MF.Picbox1.Image.Clone();
		}
		void Btn_ebenen_2_grabClick(object sender, EventArgs e)
		{
			pic_ebenen_2.Image = MF.Picbox1.Image;
			MF.Ebene_2 = (Bitmap)MF.Picbox1.Image.Clone();
		}
		void Btn_ebenen_1_loadClick(object sender, EventArgs e)
		{
			if (MF.openFileDialog1.ShowDialog() == DialogResult.OK) 
			{
				try {
					pic_ebene_1.Image = new Bitmap(MF.openFileDialog1.FileName);
					MF.Ebene_1 = new Bitmap(MF.openFileDialog1.FileName);
				} catch (Exception err) {
					MessageBox.Show(err.Message,"Fehler beim Laden");
				}
			}
		}
		void Btn_ebenen_2_loadClick(object sender, EventArgs e)
		{
			if (MF.openFileDialog1.ShowDialog() == DialogResult.OK) 
			{
				try {
					pic_ebenen_2.Image = new Bitmap(MF.openFileDialog1.FileName);
					MF.Ebene_2 = new Bitmap(MF.openFileDialog1.FileName);
				} catch (Exception err) {
					MessageBox.Show(err.Message,"Fehler beim Laden");
				}
			}
		}
		void Check_ebenen_1_onCheckedChanged(object sender, EventArgs e)
		{
			if (pic_ebene_1.Image == null) {
				check_ebenen_1_on.Checked = false;
				return;
			}
			MF.Filt_Ebenen_1_on = check_ebenen_1_on.Checked;
		}
		void Check_ebenen_2_onCheckedChanged(object sender, EventArgs e)
		{
			if (pic_ebenen_2.Image == null) {
				check_ebenen_2_on.Checked = false;
				return;
			}
			MF.Filt_Ebenen_2_on = check_ebenen_2_on.Checked;
		}
		void Panel_Ebene0Click(object sender, EventArgs e)
		{
			if (MF.colorDialog.ShowDialog() == DialogResult.OK )
			{ 
			   panel_Ebene0.BackColor = MF.colorDialog.Color;
			   MF.Filt_Ebenen_0_C = MF.colorDialog.Color;
			}
		}
		void Panel_Ebene2Click(object sender, EventArgs e)
		{
			if (MF.colorDialog.ShowDialog() == DialogResult.OK )
			{ 
			   panel_Ebene2.BackColor = MF.colorDialog.Color;
			   MF.Filt_Ebenen_2_C = MF.colorDialog.Color;
			}
		}
		void Check_ebenen_trans_sourCheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_Ebenen_0_trans_on = check_ebenen_trans_sour.Checked;
		}
		void Check_ebenen_trans_2CheckedChanged(object sender, EventArgs e)
		{
			MF.Filt_Ebenen_2_trans_on = check_ebenen_trans_2.Checked;
		}
		void num_ebene_offsetValChange(object sender, EventArgs e)
		{
			MF.Filt_Ebenen_offsetX = (int)num_ebene_offsetX.Value;
			MF.Filt_Ebenen_offsetY = (int)num_ebene_offsetY.Value;
			MF.Filt_Ebenen_offsetX2 = (int)num_ebene_offsetX2.Value;
			MF.Filt_Ebenen_offsetY2 = (int)num_ebene_offsetY2.Value;
		}
		#endregion
		

		
	}
}
